
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1380.C - Message 1380 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1380 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1380 message from the ZMsgBuf.
//
void Dec1380(tMSGBUF *ZMsgBuf, tMSG1380 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1380 message in the ZMsgBuf.
//
void Bld1380(tMSGBUF *ZMsgBuf, tMSG1380 *Msg)
{
 
   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1380                           , ZMsgBuf, 2);     // message number
   PutShort  (1                              , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
   PutBool   (Msg->RequestFlag               , ZMsgBuf, 6);     // set reprogram flag                                 
}                                            


/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1380 message from the ZMsgBuf.
//
void Show1380(tMSG1380 *Msg)
{
; // whatever
}                                                 

end not needed yet */
